//希望使用5.x版本的话,需要在package.json中更新版本号,并切换引用方式
import * as echarts from 'echarts'
import type { App } from 'vue'
import EchartContainer from './components/EchartContainer.vue'
import heNanGeoJson from './map/410000.json'
import statisticsDark from './theme/statistics-dark.json'
import statistics from './theme/statistics.json'

export { getEchartImage, useChartHighlight } from './tools'
export { EchartContainer }

/* eslint-disable @typescript-eslint/consistent-type-imports */
declare module 'vue' {
  export interface GlobalComponents {
    /** 自定义chart组件 */
    EchartContainer: typeof EchartContainer
  }
}

// app.use(echartsPlugin)
const echartsPlugin = {
  install(app: App) {
    // @ts-ignore 5.x版本注册地图
    echarts.registerMap('heNanMap', { geoJSON: heNanGeoJson })
    // echarts.registerMap('china', { geoJSON: china });
    // echarts.registerMap('china_city', { geoJSON: chinaCity });
    echarts.registerTheme('statistics', statistics)
    echarts.registerTheme('statistics-dark', statisticsDark)

    app.component('EchartContainer', EchartContainer)
  }
}

export default echartsPlugin
