import '@antv/x6/lib/model/node'
declare module '@antv/x6/lib/model/node' {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  interface Node<Properties extends Node.Properties = Node.Properties> {
    /** （自定义）显示所有的连接桩 */
    showPorts(): void
    /** （自定义）隐藏所有的连接桩 */
    hidePorts(): void

    /** layout布局之后的x位置 */
    x: number

    /** layout布局之后的y位置 */
    y: number
  }
  namespace Node {
    interface Properties {
      /** 是否是左侧占位节点 */
      isHolder?: boolean
      /** 是否是拖拽出来的节点，编辑时有效 */
      isDrag?: boolean
      /** 是否可以进行转换 */
      isCanTransform?: boolean

      /** 元素上是否禁用连接点 */
      disableProts?: boolean
      /** 是否禁用移动 */
      disableMove?: boolean
      /** 是否禁用转换 */
      disableTransform?: boolean
      /** 是否禁用选中 */
      disableSelect?: boolean
    }
  }
}

import '@antv/x6/lib/model/cell'
declare module '@antv/x6/lib/model/cell' {
  namespace Cell {
    interface EventArgs {
      /** node.prop('label','xxx') */
      'change:label': Cell.ChangeArgs<string>
      'customedit:label': Cell.ChangeArgs<string>
    }
  }
}

import '@antv/x6/lib/graph/events'

declare module '@antv/x6/lib/graph/events' {
  interface EventArgs {
    /** node.prop('label','xxx') */
    // 'change:label': Cell.ChangeArgs<string>
    // 'contextmenu:edit': { cell: Cell; ctx: ContextMenuTool }
    /** 批量添加节点 */
    // 'contextmenu:bacthCreateNode': { cell: Cell; ctx: ContextMenuTool }
    'contextmenu:remove': { args: any }
    /** 视图保存的回调 */
    'view:save': { args: any }
  }
}

import '@antv/x6'

declare module '@antv/x6' {
  interface Graph {
    /** 当history改变的时候，忽略监听的key的集合 */
    whenHistoryChangeIgnoreKeys: Set<string>
  }
}
