declare namespace DragView {
  type TextNodeData = {
    fontSize: number
    color: string
  }
  type BorderNodeData = {
    type: 'solid' | 'dashed'
    width: number
    color: string
  }

  type ImageNodeData = TextNodeData & {
    imageSize: number
    imageType: string
  }

  type EdgeData = {
    sourceMarker?: 'block'
    targetMarker?: 'block'
    strokeWidth: number
    stroke: string
    ip?: string
    autoIp?: boolean
  }
  interface NodeData {
    /** 节点IP */
    ip: string
    /** 图中代表节点个数，默认1，多个表示批量添加的 */
    count: number
    /** 可能用到的cidr */
    cidr?: string
  }
  type WiFiChannelModel = {
    type: 'WIFI'
    /** 带宽 */
    bandWidth: string
    /** 延迟 */
    delay: string
    /** 丢包率 */
    packetLossRate: string

    /** X轴起始点 */
    minX: string
    /** Y轴起始点 */
    minY: string
    /** X轴步长 */
    deltaX: string
    /** Y轴步长 */
    deltaY: string
    /** 节点数量 */
    gridWidth: string
    /** 发送增益 */
    txGain: string
    /** 接收增益 */
    rxGain: string
    /** 发送功率 */
    txPower: string
    /** 能量检测门限 */
    rxSensitivity: string
  }
}
