import type { Model } from '@antv/layout'
import { CircularLayout, ForceAtlas2Layout, RandomLayout } from '@antv/layout'
import { Edge, Node } from '@antv/x6'

/** 进行力引导布局 */
export function haveForceAtlas2Layout(model: { nodes: Node[]; edges?: Edge[] }, option?: any) {
  const forceAtlas2Layout = new ForceAtlas2Layout({
    type: 'forceAtlas2',
    preventOverlap: true,
    // width: 2000,
    // height: 1000,
    prune: false,
    kr: 1000,
    ...option
  })
  forceAtlas2Layout.layout(model as any as Model)
  model.nodes?.forEach(node => {
    node.setPosition({ x: node.x, y: node.y })
  })
}

/** 进行环形布局 */
export function haveCircularLayout(model: { nodes: Node[]; edges?: Edge[] }, option?: any) {
  const { nodes } = model
  const circularLayout = new CircularLayout({
    type: 'circular',
    preventOverlap: true,
    condense: true,
    ...option
  })
  circularLayout.layout({ nodes })
  model.nodes?.forEach(node => {
    node.setPosition({ x: node.x, y: node.y })
  })
}
/** 进行随机布局 */
export function haveRandomLayout(model: { nodes: Node[]; edges?: Edge[] }, option?: any) {
  const { nodes } = model
  const randomLayout = new RandomLayout({
    type: 'random',
    preventOverlap: true,
    condense: true,
    ...option
  })
  randomLayout.layout({ nodes })
  model.nodes?.forEach(node => {
    node.setPosition({ x: node.x, y: node.y })
  })
}

/**
 * 添加拖拽节点上的连接桩
 * @param node
 */
export function addPortsForDragNode(node: Node) {
  if (node.getProp('disableProts')) return
  node.addPort({ group: 'left' })
  node.addPort({ group: 'top' })
  node.addPort({ group: 'right' })
  node.addPort({ group: 'bottom' })
}
/**
 * 添加拖拽节点上的连接桩显示隐藏的方法
 * @param node
 */
export function registerPortFunctionForDragNode(node: Node) {
  if (node.getProp('disableProts')) return
  node.showPorts = function showPorts() {
    node.getPorts().forEach(port => {
      if (port.id) {
        node.setPortProp(port.id, {
          attrs: {
            circle: {
              stroke: '#8f8f8f',
              fill: '#fff'
            }
          }
        })
      }
    })
  }
  node.hidePorts = function hidePorts() {
    node.getPorts().forEach(port => {
      if (port.id) {
        node.setPortProp(port.id, {
          attrs: {
            circle: {
              stroke: 'transparent',
              fill: 'transparent'
            }
          }
        })
      }
    })
  }
}
