/// <reference types="./types/DragView.d.ts"/>

import { Graph } from '@antv/x6'
import { ContextMenuTool, registerCustomNode, TeleportContainer } from './components'
import './style.less'

export type { Options as GraphOptions } from '@antv/x6/lib/graph/options'
export { createImageNode } from './create'
export { registerGraphEvent } from './event'
export { registerGraphPlugin } from './plugins'
export { addPortsForDragNode, registerPortFunctionForDragNode } from './tools'
export { TeleportContainer }

// https://x6.antv.antgroup.com/tutorial/getting-started
const antvPlugin = {
  install() {
    ContextMenuTool.config({
      tagName: 'div',
      isSVGElement: false
    })
    Graph.registerEdgeTool('contextmenu', ContextMenuTool, true)
    Graph.registerNodeTool('contextmenu', ContextMenuTool, true)
    registerCustomNode()
  }
}

export default antvPlugin
