import { Graph } from '@antv/x6'
import { registerPortFunctionForDragNode } from './tools'

/** 注册x6拓扑图编辑部分的事件 */
export function registerGraphEvent(graph: Graph) {
  // 撤销重做时重新添加或初始添加时需要把showPorts的逻辑加上
  graph.on('cell:added', ({ cell /* , index, options  */ }) => {
    if (cell.isNode()) {
      const isHolder = cell.getProp('isHolder')
      if (!isHolder) {
        const view = cell.findView(graph)
        view?.addClass('x6-node-border')
        registerPortFunctionForDragNode(cell)
        cell.hidePorts?.()
      }
    }
    // @ts-ignore 有name
    const hasTools = cell.getTools()?.items.find(t => t.name === 'contextmenu')
    !hasTools && cell.addTools([{ name: 'contextmenu' }])
  })

  graph.on('node:selected', ({ /* e, */ node }) => {
    const isHolder = node.getProp('isHolder')
    const view = node.findView(graph)
    view?.removeClass('hover')
    !isHolder && node.hidePorts?.()
  })

  graph.on('node:mouseenter', ({ /* e, */ node, view, cell }) => {
    // 偶尔选中之后还能显示连接点的问题
    if (graph.getSelectedCells().find(c => c === cell)) return
    view.addClass('hover')
    const isHolder = node.getProp('isHolder')
    !isHolder && node.showPorts?.()
  })
  graph.on('node:mouseleave', ({ /* e, */ node, view }) => {
    view.removeClass('hover')
    const isHolder = node.getProp('isHolder')
    !isHolder && node.hidePorts?.()
  })
  // 自定义双击编辑label
  graph.on('node:dblclick', ({ node, cell }) => {
    graph.cleanSelection()
    graph.clearTransformWidgets()
    node.trigger('customedit:label', { cell })
  })

  // 框选箭头两边元素时自动添加连线的框选
  graph.on('selection:changed', ({ selected }) => {
    const selectedEdges = selected.filter(cell => cell.isEdge())
    const selectedNodes = selected.filter(cell => cell.isNode())
    const edges = graph.getEdges().filter(edge => !selectedEdges.includes(edge))
    edges.forEach(edge => {
      if (selectedEdges.includes(edge)) return
      const source = edge.getSourceNode()
      const target = edge.getTargetNode()
      if (!source || !target) return
      if (selectedNodes.includes(source) && selectedNodes.includes(target)) {
        graph.select(edge)
      }
    })
  })
}
