import { Node } from '@antv/x6'
import { type ImageNodeOptionI } from './constants'
export function createImageNode(option: ImageNodeOptionI) {
  const { type = 'client' } = option || {}
  return {
    shape: 'image-node', // 自定义
    width: 48,
    height: 48,
    imageType: type,
    imageSize: 36,
    ...option
  } as Node.Properties
}
export function createTextNode(option: ImageNodeOptionI) {
  return {
    shape: 'text-node', // 自定义
    ...option
  } as Node.Properties
}

export function createBorderNode(option: ImageNodeOptionI) {
  return {
    shape: 'border-node', // 自定义
    data: {
      type: 'solid',
      width: 2,
      color: '#000000'
    },
    ...option
  } as Node.Properties
}
