import ImageForContainer from './images/container.png'
import ImageForDevice from './images/device.png'
import ImageForNetwork from './images/network.png'
import ImageForNode from './images/node.png'
import ImageForPhysics from './images/physics.png'
import ImageForRoute from './images/route.png'

import type { Node } from '@antv/x6'
import type { Options as GraphOptions } from '@antv/x6/lib/graph/options'

export const ImageNodeMap = {
  node: ImageForNode,
  container: ImageForContainer, // 容器
  network: ImageForNetwork, // 交换机
  device: ImageForDevice, // 设备
  route: ImageForRoute, // 路由,
  physics: ImageForPhysics // 物理网络
}
export type ImageNodeOptionI = {
  type?: keyof typeof ImageNodeMap
} & Node.Properties

export const previewGraphOption = {
  autoResize: true,
  mousewheel: {
    enabled: true
    // modifiers: ['ctrl']
  },
  panning: true,
  interacting: { nodeMovable: false, edgeMovable: false },
  // 连线
  connecting: {
    // 吸附
    snap: false,
    allowBlank: false,
    allowLoop: false,
    allowEdge: false,
    allowNode: false,
    highlight: false,
    allowPort: false,
    allowMulti: false
  }
} as GraphOptions.Manual
