import { getTeleport, register } from '@antv/x6-vue-shape'
import BorderNode from './BorderNode.vue'
import ContextMenu from './ContextMenu.vue'
import { ContextMenuTool } from './ContextMenuTool'
import ImageNode from './ImageNode.vue'
import TextNode from './TextNode.vue'

export const TeleportContainer = getTeleport()
export { ContextMenu, ContextMenuTool }

export function registerCustomNode() {
  register({
    shape: 'image-node',
    data: { fontSize: 12, color: '#000000', imageSize: 36 },
    width: 48,
    height: 48,
    component: ImageNode
  })
  register({
    shape: 'text-node',
    data: { fontSize: 12, color: '#000000' },
    width: 48,
    height: 24,
    component: TextNode
  })

  register({
    shape: 'border-node',
    width: 100,
    height: 60,
    component: BorderNode
  })
}
